import { fetchVideo } from '@/actions/fetchPost'
import MaxWidthContainer from '@/components/max-width-container'
import { format } from 'date-fns'
import React from 'react'

async function VideoPage({ params }) {
    const slug = await params.videoSlug
    const { data: data } = await fetchVideo(slug)

    return (
        <MaxWidthContainer>
            <div className="max-w-5xl w-full flex flex-col gap-4 ">
                {data && (
                    <div className="">
                        <iframe
                            className="w-full aspect-video"
                            src={`https://www.youtube.com/embed/${data.videoId}`}
                            title="YouTube video player"
                            frameBorder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            referrerPolicy="strict-origin-when-cross-origin"
                            allowfullscreen />
                        <div className=" w-full">
                            <h2 className="font-bold text-sm sm:text-lg">
                                {data.title}
                            </h2>
                            <p className="">
                                {format(
                                    new Date(data.created_at),
                                    'MMMM dd, yyyy , hh:mm a',
                                )}
                            </p>
                            <p className="">{data.description}</p>
                        </div>
                    </div>
                )}
            </div>
            <div className="relative w-full sm:max-w-xs">
                <div className=" grid place-content-center w-full bg-emerald-400 text-black aspect-square p-2">
                    <p>Advertisment</p>
                </div>
            </div>
        </MaxWidthContainer>
    )
}

export default VideoPage
